/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import util.LRUCache;
import util.Utils;

public class BlockedUrls
implements Set {
    private static int MAXPREFIX_LEN = 20;
    private LRUCache okCache;
    private LRUCache filterListCache;
    private Hashtable urlFilterOverRule;
    private int sharedLocks = 0;
    private boolean exclusiveLock = false;
    private Vector blockedURLs;

    public BlockedUrls(int okCacheSize, int filterListCacheSize, Hashtable urlFilterOverRule) {
        this.okCache = new LRUCache(okCacheSize);
        this.filterListCache = new LRUCache(filterListCacheSize);
        this.urlFilterOverRule = urlFilterOverRule;
        this.blockedURLs = new Vector();
    }

    public void appyList(InputStream in) throws IOException {
        this.lock(1);
        try {
            String entry;
            this.clear();
            BufferedReader rin = new BufferedReader(new InputStreamReader(in));
            while ((entry = rin.readLine()) != null) {
                if ((entry = entry.trim()).startsWith("#") || entry.equals("")) continue;
                this.blockedURLs.addElement(entry.trim().split("\\*", -1));
            }
            rin.close();
        }
        finally {
            this.unLock(1);
        }
    }

    public synchronized void lock(int type) {
        if (type == 0) {
            while (this.exclusiveLock) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++this.sharedLocks;
        } else if (type == 1) {
            while (this.sharedLocks != 0 || this.exclusiveLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.exclusiveLock = true;
        }
    }

    public synchronized void unLock(int type) {
        if (type == 0) {
            if (this.sharedLocks > 0) {
                --this.sharedLocks;
                if (this.sharedLocks == 0) {
                    this.notifyAll();
                }
            }
        } else if (type == 1 && this.exclusiveLock) {
            this.exclusiveLock = false;
            this.notifyAll();
        }
    }

    @Override
    public boolean add(Object host) {
        throw new UnsupportedOperationException("Not supported!");
    }

    private String prefix(String str, int len) {
        if (str == null) {
            return null;
        }
        return str.substring(0, Math.min(str.length(), len));
    }

    private boolean isPrefix(String str, String prefix, int len) {
        return this.prefix(str, len).equals(prefix);
    }

    @Override
    public boolean contains(Object object) {
        try {
            this.lock(0);
            String url = (String)object;
            if (this.isPrefix(url, (String)this.okCache.get(Utils.getLongStringHash(url)), MAXPREFIX_LEN)) {
                return false;
            }
            if (this.isPrefix(url, (String)this.filterListCache.get(Utils.getLongStringHash(url)), MAXPREFIX_LEN)) {
                return true;
            }
            if (this.containsMatch(url)) {
                this.filterListCache.put((Object)Utils.getLongStringHash(url), this.prefix(url, MAXPREFIX_LEN));
                return true;
            }
            this.okCache.put((Object)Utils.getLongStringHash(url), this.prefix(url, MAXPREFIX_LEN));
            return false;
        }
        finally {
            this.unLock(0);
        }
    }

    private boolean containsMatch(String url) {
        Object val;
        if (this.urlFilterOverRule != null && (val = this.urlFilterOverRule.get(url)) != null) {
            return (Boolean)val;
        }
        for (String[] fixedParts : this.blockedURLs) {
            if (!BlockedUrls.wildCardMatch(fixedParts, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean wildCardMatch(String[] fixedParts, String url) {
        int i = 0;
        while (i < fixedParts.length) {
            String part = fixedParts[i];
            int idx = -1;
            idx = i < fixedParts.length - 1 ? url.indexOf(part) : url.lastIndexOf(part);
            if (i == 0 && !part.equals("") && idx != 0) {
                return false;
            }
            if (i == fixedParts.length - 1 && !part.equals("") && idx + part.length() != url.length()) {
                return false;
            }
            if (idx == -1) {
                return false;
            }
            url = url.substring(idx + part.length());
            ++i;
        }
        return true;
    }

    @Override
    public void clear() {
        this.blockedURLs.clear();
        this.filterListCache.clear();
        this.okCache.clear();
    }

    @Override
    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean containsAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Object[] toArray(Object[] array) {
        throw new UnsupportedOperationException("Not supported!");
    }
}

