/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import util.HugePackedSet;
import util.LRUCache;
import util.ObjectPackagingManager;
import util.Utils;

public class BlockedHosts
implements Set {
    private static ObjectPackagingManager PACK_MGR = new MyPackagingManager();
    private static Object NOT_NULL = new Object();
    private LRUCache okCache;
    private LRUCache filterListCache;
    private Hashtable hostsFilterOverRule;
    private int sharedLocks = 0;
    private boolean exclusiveLock = false;
    private HugePackedSet blockedHostsHashes;

    public BlockedHosts(int maxCountEstimate, int okCacheSize, int filterListCacheSize, Hashtable hostsFilterOverRule) {
        this.okCache = new LRUCache(okCacheSize);
        this.filterListCache = new LRUCache(filterListCacheSize);
        this.hostsFilterOverRule = hostsFilterOverRule;
        int slots = maxCountEstimate / 6000;
        if (slots % 2 == 0) {
            ++slots;
        }
        this.blockedHostsHashes = new HugePackedSet(slots, PACK_MGR);
    }

    private BlockedHosts(HugePackedSet blockedHostsHashes, int okCacheSize, int filterListCacheSize, Hashtable hostsFilterOverRule) {
        this.blockedHostsHashes = blockedHostsHashes;
        this.okCache = new LRUCache(okCacheSize);
        this.filterListCache = new LRUCache(filterListCacheSize);
        this.hostsFilterOverRule = hostsFilterOverRule;
    }

    public synchronized void lock(int type) {
        if (type == 0) {
            while (this.exclusiveLock) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++this.sharedLocks;
        } else if (type == 1) {
            while (this.sharedLocks != 0 || this.exclusiveLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.exclusiveLock = true;
        }
    }

    public synchronized void unLock(int type) {
        if (type == 0) {
            if (this.sharedLocks > 0) {
                --this.sharedLocks;
                if (this.sharedLocks == 0) {
                    this.notifyAll();
                }
            }
        } else if (type == 1 && this.exclusiveLock) {
            this.exclusiveLock = false;
            this.notifyAll();
        }
    }

    public static boolean checkIndexVersion(String path) throws IOException {
        return HugePackedSet.checkIndexVersion(path);
    }

    public static BlockedHosts loadPersistedIndex(String path, boolean inMemory, int okCacheSize, int filterListCacheSize, Hashtable hostsFilterOverRule) throws IOException {
        return new BlockedHosts(HugePackedSet.load(path, inMemory, PACK_MGR), okCacheSize, filterListCacheSize, hostsFilterOverRule);
    }

    public void persist(String path) throws IOException {
        this.blockedHostsHashes.persist(path);
    }

    public void prepareInsert(String host) {
        this.blockedHostsHashes.prepareInsert(Utils.getLongStringHash(host));
    }

    public void finalPrepare() {
        this.blockedHostsHashes.finalPrepare();
    }

    @Override
    public boolean add(Object host) {
        return this.blockedHostsHashes.add((Object)Utils.getLongStringHash((String)host));
    }

    @Override
    public boolean contains(Object object) {
        try {
            this.lock(0);
            String hostName = (String)object;
            long hosthash = Utils.getLongStringHash(hostName);
            if (this.okCache.get(hosthash) != null) {
                return false;
            }
            if (this.filterListCache.get(hosthash) != null) {
                return true;
            }
            if (this.contains(hostName, hosthash)) {
                this.filterListCache.put((Object)hosthash, NOT_NULL);
                return true;
            }
            this.okCache.put((Object)hosthash, NOT_NULL);
            return false;
        }
        finally {
            this.unLock(0);
        }
    }

    private boolean contains(String hostName, long hosthash) {
        Object val;
        if (this.hostsFilterOverRule != null && (val = this.hostsFilterOverRule.get(hostName)) != null) {
            return (Boolean)val;
        }
        if (this.blockedHostsHashes.contains(hosthash)) {
            return true;
        }
        int idx = hostName.indexOf(46);
        while (idx != -1) {
            Object val2;
            hostName = hostName.substring(idx + 1);
            if (this.hostsFilterOverRule != null && (val2 = this.hostsFilterOverRule.get(hostName)) != null) {
                return (Boolean)val2;
            }
            if (this.blockedHostsHashes.contains(Utils.getLongStringHash(hostName))) {
                return true;
            }
            idx = hostName.indexOf(46);
        }
        return false;
    }

    @Override
    public void clear() {
        this.blockedHostsHashes.clear();
        this.filterListCache.clear();
        this.okCache.clear();
    }

    protected void migrateTo(BlockedHosts hostFilter) {
        this.okCache.clear();
        this.okCache = hostFilter.okCache;
        this.filterListCache.clear();
        this.filterListCache = hostFilter.filterListCache;
        this.hostsFilterOverRule = hostFilter.hostsFilterOverRule;
        this.blockedHostsHashes.migrateTo(hostFilter.blockedHostsHashes);
    }

    @Override
    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean containsAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean isEmpty() {
        return this.blockedHostsHashes.isEmpty();
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public int size() {
        return this.blockedHostsHashes.size();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Object[] toArray(Object[] array) {
        throw new UnsupportedOperationException("Not supported!");
    }

    private static class MyPackagingManager
    implements ObjectPackagingManager {
        private MyPackagingManager() {
        }

        @Override
        public int objectSize() {
            return 8;
        }

        @Override
        public Object bytesToObject(byte[] data, int offs) {
            return Utils.byteArrayToLong(data, offs);
        }

        @Override
        public void objectToBytes(Object object, byte[] data, int offs) {
            Utils.writeLongToByteArray((Long)object, data, offs);
        }
    }
}

