/*
 * Decompiled with CFR 0.152.
 */
package httpproxy;

import httpproxy.ChunkedDataTransfer;
import httpproxy.HttpProxyServer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import util.Logger;
import util.http.HttpHeader;

public class HttpProxyResponse
extends InputStream {
    private static String HEXFILLSTR = "00000000";
    private static int STATIC_HEADER_LEN = HEXFILLSTR.length();
    private static int MIN_CHUNK_LEN = 512;
    private HttpProxyServer server;
    private ByteArrayInputStream headerIn = null;
    private InputStream srvHttp_In = null;
    private byte[] chunk = null;
    private boolean finalChunk = false;
    private int chunkOffs = 0;
    private int chunkCount = 0;
    private long contentLength = 0L;
    private boolean chunkedSrvRes = false;
    private boolean chunkedProxyRes = false;
    private int contentSent = 0;
    private ChunkedDataTransfer chunkedTransfer = null;
    private boolean responseComplete = false;
    private boolean connectionClose = false;
    private boolean eof = false;
    private boolean ssl = false;
    private int available = 0;
    private boolean closed = false;

    public HttpProxyResponse(HttpProxyServer server) {
        this.server = server;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int r = this.read(b);
        if (r == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private String getFixedLengthHexString(int number) {
        String hexStr = Integer.toHexString(number);
        hexStr = String.valueOf(HEXFILLSTR.substring(0, STATIC_HEADER_LEN - hexStr.length())) + hexStr;
        return hexStr;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int r = this.readInternal(b, off, len);
        this.server.resetIdleTimeOut();
        return r;
    }

    private synchronized int readInternal(byte[] b, int off, int len) throws IOException {
        if (this.server.closed) {
            throw new IOException("Server already closed!");
        }
        if (this.server.current_status != 7 && this.server.current_status != 6) {
            try {
                this.wait(this.server.soTimeout);
                if (this.server.current_status != 7 && this.server.current_status != 6 && this.server.soTimeout != 0) {
                    throw new SocketTimeoutException();
                }
                if (this.server.closed) {
                    throw new IOException("Server already closed!");
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (this.eof) {
            return -1;
        }
        if (this.server.current_status == 6) {
            int r = this.headerIn.read(b, off, Math.min(len, this.headerIn.available()));
            this.available = this.headerIn.available();
            if (this.headerIn.available() == 0) {
                this.server.current_status = (byte)7;
                this.headerIn = null;
                if (this.contentLength == 0L && !this.chunkedSrvRes) {
                    this.responseComplete = true;
                    this.server.responseFinished(!this.connectionClose);
                }
            }
            return r;
        }
        if (this.server.current_status == 7) {
            if (this.chunkedProxyRes) {
                if (this.chunkOffs == this.chunkCount) {
                    int chunkSize = this.getBestSize(len);
                    if (len >= chunkSize + STATIC_HEADER_LEN + 4) {
                        int count = this.srvHttp_In.read(b, STATIC_HEADER_LEN + 2, chunkSize);
                        if (count == -1) {
                            System.arraycopy("0\r\n\r\n".getBytes(), 0, b, 0, 5);
                            this.server.responseFinished(this.chunkedSrvRes && !this.connectionClose);
                            this.responseComplete = true;
                            return 5;
                        }
                        byte[] hexheader = (String.valueOf(this.getFixedLengthHexString(count)) + "\r\n").getBytes();
                        System.arraycopy(hexheader, 0, b, 0, STATIC_HEADER_LEN + 2);
                        b[count + HttpProxyResponse.STATIC_HEADER_LEN + 2] = 13;
                        b[count + HttpProxyResponse.STATIC_HEADER_LEN + 3] = 10;
                        return count + STATIC_HEADER_LEN + 4;
                    }
                    this.chunk = new byte[chunkSize];
                    this.chunkCount = this.srvHttp_In.read(this.chunk);
                    if (this.chunkCount != -1) {
                        byte[] chunkHeader = (String.valueOf(this.getFixedLengthHexString(this.chunkCount)) + "\r\n").getBytes();
                        byte[] fullChunk = new byte[chunkHeader.length + this.chunkCount + 2];
                        System.arraycopy(chunkHeader, 0, fullChunk, 0, chunkHeader.length);
                        System.arraycopy(this.chunk, 0, fullChunk, chunkHeader.length, this.chunkCount);
                        fullChunk[fullChunk.length - 2] = 13;
                        fullChunk[fullChunk.length - 1] = 10;
                        this.chunk = fullChunk;
                    } else {
                        this.finalChunk = true;
                        this.chunk = "0\r\n\r\n".getBytes();
                    }
                    this.chunkCount = this.chunk.length;
                    this.chunkOffs = 0;
                    this.available = this.chunkCount;
                }
                int count = Math.min(this.available, len);
                System.arraycopy(this.chunk, this.chunkOffs, b, off, count);
                this.chunkOffs += count;
                this.available = this.chunkCount - this.chunkOffs;
                if (this.finalChunk && this.chunkOffs == this.chunkCount) {
                    this.server.responseFinished(this.chunkedSrvRes && !this.connectionClose);
                    this.responseComplete = true;
                }
                return count;
            }
            if (this.chunkedSrvRes) {
                int r = this.srvHttp_In.read(b, off, len);
                this.available = this.srvHttp_In.available();
                if (!this.chunkedTransfer.write(b, off, r)) {
                    if (this.chunkedTransfer.lastBytesProcessed != r) {
                        throw new IOException(String.valueOf(r - this.chunkedTransfer.lastBytesProcessed) + " bytes left in chunked HTTP Response but final chunk received!");
                    }
                    this.server.responseFinished(!this.connectionClose);
                    this.responseComplete = true;
                    this.chunkedTransfer = null;
                }
                return r;
            }
            if (this.contentLength > 0L) {
                int r = this.srvHttp_In.read(b, off, (int)Math.min((long)len, this.contentLength));
                this.available = this.srvHttp_In.available();
                this.contentSent += r;
                if ((long)this.contentSent == this.contentLength) {
                    this.server.responseFinished(!this.connectionClose);
                    this.responseComplete = true;
                }
                return r;
            }
            if (this.ssl) {
                int r = this.srvHttp_In.read(b, off, len);
                this.available = this.srvHttp_In.available();
                if (r == -1) {
                    this.server.responseFinished(false);
                    this.responseComplete = true;
                    this.eof = true;
                }
                return r;
            }
        }
        throw new IOException("Invalid state!");
    }

    private int getBestSize(int len) {
        if (len < MIN_CHUNK_LEN) {
            return MIN_CHUNK_LEN;
        }
        return len - STATIC_HEADER_LEN - 4;
    }

    public synchronized void startResponse(HttpHeader header, InputStream in, boolean ssl) {
        HttpHeader resHeader;
        block11: {
            this.responseComplete = false;
            this.chunkedProxyRes = false;
            this.chunkedSrvRes = false;
            this.eof = false;
            this.contentSent = 0;
            this.srvHttp_In = in;
            this.ssl = ssl;
            resHeader = header;
            this.server.resetIdleTimeOut();
            if (resHeader == null) {
                try {
                    if (!ssl) {
                        try {
                            this.server.setHttpServerReadTimeOut(120000);
                            resHeader = new HttpHeader(in, 2);
                            if (resHeader.getResponseCode() == 100) {
                                resHeader = new HttpHeader(in, 2);
                            }
                            break block11;
                        }
                        finally {
                            this.server.setHttpServerReadTimeOut(this.server.soTimeout);
                        }
                    }
                    resHeader = new HttpHeader("HTTP/1.1 200 Connection established\r\nProxy-agent: Personal-Proxy/1.1", 2);
                }
                catch (IOException e) {
                    this.startErrorResponse("HTTP/1.1 500 No valid Reponse from server!", "No valid Reponse from server!\r\n" + e.getMessage());
                    return;
                }
            }
        }
        this.connectionClose = resHeader.getConnectionClose();
        resHeader.setValue("Connection", "Keep-Alive");
        this.contentLength = resHeader.getContentLength();
        this.chunkedSrvRes = resHeader.chunkedTransfer();
        if (this.chunkedSrvRes) {
            this.chunkedTransfer = new ChunkedDataTransfer(null);
        } else if (this.contentLength == -1L && !ssl) {
            resHeader.setValue("Transfer-Encoding", "chunked");
            this.chunkedProxyRes = true;
            this.chunkOffs = 0;
            this.chunkCount = 0;
            this.finalChunk = false;
        }
        this.headerIn = new ByteArrayInputStream(resHeader.getHeaderString().getBytes());
        this.available = this.headerIn.available();
        this.server.current_status = (byte)6;
        this.notifyAll();
    }

    @Override
    public void close() {
        this.server.close();
    }

    public synchronized void closeResponse() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.notifyAll();
    }

    public void startErrorResponse(String status, String body) {
        try {
            HttpHeader header = new HttpHeader(String.valueOf(status) + "\r\n", 2);
            header.setValue("Content-Length", "" + body.length());
            header.setValue("Connection", "close");
            this.startResponse(null, new ByteArrayInputStream((String.valueOf(header.getHeaderString()) + body).getBytes()), false);
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }
}

