/*
 * Decompiled with CFR 0.152.
 */
package httpproxy;

import java.io.IOException;
import java.io.OutputStream;

public class ChunkedDataTransfer {
    private OutputStream out;
    private static int TRAILEREND = 0xD0A0D0A;
    private static short LINEEND = (short)3338;
    private StringBuffer chunkHeader = new StringBuffer();
    private int remainingChunkLength = 0;
    private boolean chunkedRequestTermination = false;
    private boolean chunkTermination = false;
    private short last2Bytes = 0;
    private int last4Bytes = 0;
    public int lastBytesProcessed;

    public ChunkedDataTransfer(OutputStream out) {
        this.out = out;
    }

    public boolean write(int b) throws IOException {
        return this.write(new byte[]{(byte)b}, 0, 1);
    }

    private void writeThrough(byte[] buf, int offs, int len) throws IOException {
        if (this.out != null) {
            this.out.write(buf, offs, len);
        }
    }

    public boolean write(byte[] buf, int offs, int length) throws IOException {
        boolean allBytesProcessed = false;
        int len = length;
        this.lastBytesProcessed = 0;
        while (!allBytesProcessed) {
            if (this.remainingChunkLength != 0 && !this.chunkTermination) {
                int len2process = Math.min(len, this.remainingChunkLength);
                this.remainingChunkLength -= len2process;
                this.writeThrough(buf, offs, len2process);
                if (this.remainingChunkLength == 0) {
                    this.chunkTermination = true;
                    this.remainingChunkLength = 2;
                }
                offs += len2process;
                allBytesProcessed = (len -= len2process) == 0;
                continue;
            }
            if (this.chunkTermination) {
                this.last2Bytes = (short)((this.last2Bytes << 8) + (buf[offs] & 0xFF));
                --this.remainingChunkLength;
                this.writeThrough(buf, offs, 1);
                ++offs;
                boolean bl = allBytesProcessed = --len == 0;
                if (this.remainingChunkLength != 0) continue;
                if (this.last2Bytes != LINEEND) {
                    throw new IOException("Invalid Chunk Termination!");
                }
                if (this.out != null) {
                    this.out.flush();
                }
                this.chunkHeader = new StringBuffer();
                this.chunkTermination = false;
                this.last2Bytes = 0;
                continue;
            }
            if (this.chunkHeader != null) {
                this.chunkHeader.append((char)(buf[offs] & 0xFF));
                this.last2Bytes = (short)((this.last2Bytes << 8) + (buf[offs] & 0xFF));
                if (this.last2Bytes == LINEEND) {
                    this.last2Bytes = 0;
                    try {
                        this.remainingChunkLength = Integer.parseInt(this.chunkHeader.toString().trim(), 16);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("Can not parse ChunkHeader to HEX Number:" + this.chunkHeader.toString().trim());
                    }
                    if (this.remainingChunkLength == 0) {
                        this.chunkedRequestTermination = true;
                        this.last4Bytes = LINEEND;
                    }
                    this.chunkHeader = null;
                }
                this.writeThrough(buf, offs, 1);
                ++offs;
                allBytesProcessed = --len == 0;
                continue;
            }
            if (this.chunkedRequestTermination) {
                this.last4Bytes = (this.last4Bytes << 8) + (buf[offs] & 0xFF);
                this.writeThrough(buf, offs, 1);
                ++offs;
                boolean bl = allBytesProcessed = --len == 0;
                if (this.last4Bytes != TRAILEREND) continue;
                if (this.out != null) {
                    this.out.flush();
                }
                this.lastBytesProcessed = this.lastBytesProcessed + length - len;
                return false;
            }
            throw new IOException("Invalid ChunkedDataTransfer State!");
        }
        this.lastBytesProcessed += length;
        return true;
    }

    public void initChunkedTransfer() {
        this.chunkHeader = new StringBuffer();
        this.remainingChunkLength = 0;
        this.chunkedRequestTermination = false;
        this.chunkTermination = false;
        this.chunkTermination = false;
        this.last2Bytes = 0;
    }
}

